/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2004 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

   #region DBWebLabeledTextBox

	public enum LabelPosition
   {
   	LabelToLeft,
		LabelAbove,
		LabelToRight,
		LabelBelow
	}

	/// <summary>
	/// Data aware Label control for use with DBWebDataSource
	/// </summary>

	[Designer("Borland.Data.Web.DBWebControlDesigner"),
	ToolboxBitmap(typeof(Borland.Data.Web.DBWebLabeledTextBox),
	"Borland.Data.Web.DBWebLabeledTextBox.bmp"),
	ToolboxData("<{0}:DBWebLabeledTextBox runat=server></{0}:DBWebLabeledTextBox>")]
	public class DBWebLabeledTextBox : WebControl, IDBWebColumnLink, IPostBackDataHandler
	{
		private const int minWidth = 120;
		private const string childPrefix = "TB_";
		private const string defaultTextBoxPortion = "100%";
		private string FTextBoxPortion;
		private LabelPosition FLabelPosition;
		private Label FLabel;
		private System.Web.UI.WebControls.Panel FPanel;
		private Color FCaptionBackColor;
		private Color FCaptionForeColor;
		private DBWebColumnLink FColumnLink;
		private IDBWebColumnLink IColumnLink;
		private TextBox FTextBox;
		private bool FReadOnly;
		private bool FCaptionFontBold;
		private bool FCaptionFontItalic;
		private bool FCaptionFontUnderline;
		private bool FCaptionFontOverline;
		private FontUnit FCaptionFontSize;


   	public DBWebLabeledTextBox() : base()
      {
      	FTextBox = new TextBox();
         FLabel = new Label();
         FPanel = new System.Web.UI.WebControls.Panel();
      	FTextBoxPortion = defaultTextBoxPortion;
         FLabelPosition = LabelPosition.LabelToLeft;
         FColumnLink = new DBWebColumnLink(this);
			IColumnLink = (FColumnLink as IDBWebColumnLink);
			FReadOnly = false;
			FPanel.Width = new Unit(minWidth);
			FTextBox.Width = new Unit(minWidth -2);
			LabelAndTextSize();
		}

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
			if( s != null )
				return;
			DataBind();
			if( !ReadOnly )
				Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

            #region Layout
		[LocalizableCategoryAttribute("Layout")]
      public override Unit Width
      {
      	get
         {
         	return FPanel.Width;
         }
         set
			{
				base.Width = value;
				FPanel.Width = value;
				LabelAndTextSize();
			}
		}


		[LocalizableCategoryAttribute("Layout")]
		public override Unit Height
		{
			get
			{
				return FPanel.Height;
			}
			set
			{
				base.Height = value;
				FPanel.Height = value;
			}
		}



		#endregion Layout
		#region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return IColumnLink .DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
		#endregion
		#region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
		#endregion

		[Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("TableName")]
		public string TableName
		{
			get
			{
				return IColumnLink.TableName;
			}
			set
			{
				IColumnLink.TableName = value;
			}
		}
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		[LocalizableDescriptionAttribute("DataSource")]
		public IDBDataSource DBDataSource
		{
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }


      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }

		[LocalizableCategoryAttribute("Behavior"),
		DefaultValue(false)]
	  [LocalizableDescriptionAttribute("ReadOnly")]
      public bool ReadOnly
      {
      	get
         {
	      	return FReadOnly;
         }
      	set
         {
	      	FReadOnly = value;
         }
      }
      
      protected string ChildPrefix
      {
      	get
         {
         	return childPrefix;
         }
      }

		private int PercentValue( string s )
		{
			try
			{
				int iPercentPos = s.IndexOf("%" );
				string sNumber = s.Substring(0, iPercentPos);
				int iPercent = Convert.ToInt32(sNumber);
				if( iPercent > 0 && iPercent < 101 )
					return iPercent;
			}
			catch
			{
				// invalid percent value: don't use
         }
         return -1;
		}

		#region caption properties
		[LocalizableCategoryAttribute("Caption"),
      DefaultValue("")]
      [LocalizableDescriptionAttribute("CaptionPI")]
      public string Caption
      {
      	get
         {
         	return FLabel.Text;
         }
         set
         {
            if( FLabel.Text != value )
            {
         		FLabel.Text = value;
               if( FTextBoxPortion == defaultTextBoxPortion )
               	FTextBoxPortion = "50%";
            }
         }
      }

		[LocalizableCategoryAttribute("Caption"),
		DefaultValue("LabelPosition.LabelOnTop")]
		[LocalizableDescriptionAttribute("CaptionPosition")]
		public LabelPosition CaptionPosition
		{
			get
			{
				return FLabelPosition;
			}
			set
			{
				FLabelPosition = value;
				LabelAndTextSize();
			}
      }

		[LocalizableCategoryAttribute("Caption"),
      DefaultValue("100%")]
		[LocalizableDescriptionAttribute("TextPortion")]
		public string TextBoxPortion
		{
			get
			{
				return FTextBoxPortion;
			}
			set
			{
				if( FTextBoxPortion != value )
				{
					int iPercentPos = value.IndexOf("%" );
					if( iPercentPos < 0 )
						value = value + "%";
					if( PercentValue( value ) != -1 )
						FTextBoxPortion = value;
					LabelAndTextSize();
				}
			}
		}
		[LocalizableCategoryAttribute("Caption")]
		[LocalizableDescriptionAttribute("CaptionBackColor")]
		public Color CaptionBackColor
		{
      	get
         {
         	return FCaptionBackColor;
         }
         set
         {
         	FCaptionBackColor = value;
         }
      }

		[LocalizableCategoryAttribute("Caption")]
	  [LocalizableDescriptionAttribute("CaptionForeColor")]
      public Color CaptionForeColor
      {
      	get
         {
         	return FCaptionForeColor;
         }
         set
         {
         	FCaptionForeColor = value;
         }
      }

		[LocalizableCategoryAttribute("Caption")]
	  [LocalizableDescriptionAttribute("CaptionFontItalic")]
      public bool CaptionFontItalic
      {
      	get
         {
         	return FCaptionFontItalic;
         }
         set
         {
         	FCaptionFontItalic = value;
         }
      }

		[LocalizableCategoryAttribute("Caption")]
	  [LocalizableDescriptionAttribute("CaptionFontUnderline")]
      public bool CaptionFontUnderline
      {
      	get
         {
         	return FCaptionFontUnderline;
         }
         set
         {
         	FCaptionFontUnderline = value;
         }
      }
		[LocalizableCategoryAttribute("Caption")]
	  [LocalizableDescriptionAttribute("CaptionFontOverLine")]
      public bool CaptionFontOverline
      {
      	get
         {
         	return FCaptionFontOverline;
         }
         set
         {
         	FCaptionFontOverline = value;
         }
      }
		[LocalizableCategoryAttribute("Caption")]
	  [LocalizableDescriptionAttribute("CaptionFontSize")]
      public FontUnit CaptionFontSize
		{
			get
			{
				return FCaptionFontSize;
			}
			set
			{
				FCaptionFontSize = value;
			}
		}

		[LocalizableCategoryAttribute("Caption")]
		[LocalizableDescriptionAttribute("CaptionFontBold")]
		public bool CaptionFontBold
      {
      	get
         {
         	return FCaptionFontBold;
         }
         set
         {
         	FCaptionFontBold = value;
         }
      }
      #endregion

      public string ControlID()
		{
			return ChildPrefix + this.ID;
		}

		private void SetLabelProps( )
		{
			FLabel.BackColor = FCaptionBackColor;
			FLabel.ForeColor = FCaptionForeColor;
		}

		private void SetControlSize(WebControl control, int portion)
		{
			double percent = (Convert.ToDouble(portion) / 100);
			double dSize;
			dSize = (FPanel.Width.Value * percent) - ( (FPanel.BorderWidth.Value) * 2);
			control.Width = new Unit(dSize);
		}

		private void LabelAndTextSize()
		{
			SetLabelProps();
			int iTextPortion;
			Double Adjust = FPanel.BorderWidth.Value *2;
			if( FLabelPosition == LabelPosition.LabelAbove ||
					FLabelPosition == LabelPosition.LabelBelow )
			{
				FPanel.Wrap = true;
				FTextBox.Width = new Unit(FPanel.Width.Value - Adjust);
				FLabel.Width = new Unit(FPanel.Width.Value - Adjust);
			}
			else
			{
				FPanel.Wrap = false;
				iTextPortion = PercentValue(FTextBoxPortion);
				if( iTextPortion == -1 )
					iTextPortion = 50;

				SetControlSize(FTextBox, iTextPortion);
				if( !ClassUtils.IsEmpty(this.Caption) )
					SetControlSize(FLabel, 100 - iTextPortion);
			}
		}

      private void SetLabelFont()
      {
      	FLabel.Font.Bold = FCaptionFontBold;
      	FLabel.Font.Italic = FCaptionFontItalic;
      	FLabel.Font.Overline = FCaptionFontOverline;
      	FLabel.Font.Underline = FCaptionFontUnderline;
      	FLabel.Font.Size = FCaptionFontSize;
      }

		public override void DataBind()
      {
      	try
         {
	         FTextBox.ReadOnly = FReadOnly;
   	   	FTextBox.ID = this.ID;
      		base.DataBind();
         	ClassUtils.SetBehaviorProperties(FPanel, this);
	         ClassUtils.SetOuterAppearanceProperties(FPanel, this);
   	      ClassUtils.SetSizeProperties(FPanel, this);
      	   if( !ClassUtils.IsEmpty(FLabel.Text) )
         	{
					ClassUtils.SetInnerAppearanceProperties(FLabel, this);
					SetLabelFont();
					FTextBox.Text = null;
				}
				if( IColumnLink.DBDataSource != null )
				{
					if( FColumnLink.IsDataBound )
					{
						ClassUtils.SetBehaviorProperties(FTextBox, this);
						ClassUtils.SetInnerAppearanceProperties(FTextBox, this);
						ClassUtils.SetSizeProperties(FTextBox, this);
						object o = IColumnLink.DBDataSource.GetColumnValue(Page,
								IColumnLink.TableName, IColumnLink.ColumnName);
						if( o != null )
							FTextBox.Text = Convert.ToString(o);
						else
							FTextBox.Text = "";
						FTextBox.DataBind();
						LabelAndTextSize();
					}
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }

		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
				output.Write(Text);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		protected string Text
		{
			get
			{
         	StringWriter sw = new StringWriter();
				HtmlTextWriter tw = new HtmlTextWriter(sw);
            ClassUtils.AddStyleToWebControl(FPanel, this.Style);
            FPanel.RenderBeginTag(tw);
            string text = sw.ToString();
            if( ClassUtils.IsEmpty(FLabel.Text) )
            {
            	FTextBox.Width = this.Width;
               FTextBox.Height = this.Height;
            }
            if( FLabelPosition == LabelPosition.LabelAbove ||
            		FLabelPosition == LabelPosition.LabelToLeft )
            {
      			if( !ClassUtils.IsEmpty(FLabel.Text) )
            		FLabel.RenderControl(tw);
            	FTextBox.RenderControl(tw);
            }
            else
            {
            	FTextBox.RenderControl(tw);
      			if( !ClassUtils.IsEmpty(FLabel.Text) )
            		FLabel.RenderControl(tw);
            }
            if( text != null )
            	text = sw.ToString();
            FPanel.RenderEndTag(tw);
            if( text != null )
            	text = sw.ToString();
            return sw.ToString();
			}
		}

   }
   #endregion
}
